#include (occupation.inc)

[top]
components : occupation

[occupation]
type : cell
dim : (10,22,2,4)
delay : inertial
defaultDelayTime : 100
border : nowrapped 
neighbors : occu(-1,-1,0,0) occu(-1,0,0,0) occu(-1,1,0,0) %movement
neighbors : occu(0,-1,0,0)  occu(0,0,0,0)  occu(0,1,0,0) 
neighbors : occu(1,-1,0,0)  occu(1,0,0,0)  occu(1,1,0,0)
neighbors :                 occu(0,0,-1,0)                %downstair
neighbors :                 occu(0,0,1,0)                 %upstair
neighbors :                 occu(-1,0,0,1)                %pathway
neighbors : occu(0,-1,0,1)  occu(0,0,0,1)  occu(0,1,0,1) 
neighbors :                 occu(1,0,0,1) 
neighbors :                 occu(0,0,0,2)                 %layout
neighbors :                 occu(0,0,0,3)                 %hotzone

initialvalue : 0
initialCellsValue : occupation.val

localtransition : nothing
zone : movement { (0,0,0,0)..(9,21,1,0) }
zone : pathway { (0,0,0,1)..(9,21,1,1) }
zone : layout { (0,0,0,2)..(9,21,1,2) }
zone : hotzone { (0,0,0,3)..(9,21,1,3) }

[nothing]
rule : {(0,0,0,0)} 100 { t } 

[movement]
%initial //gate, on path way, simulation multiple of 400 //if(uniform(0,1)<0.1, 0, 1)
rule : {1} 400 { remainder(time, #Macro(VisitorFrequency))=0 and (0,0,0,0)=0 and (0,0,0,2)=3 and (0,0,0,1)>=5 }

%exit //when occupied, leave for empty
rule : {0} 100 { (0,0,0,2)=4 and (0,0,0,0)=1} 

%phase 1: intent //if pathway done, order: %F; %LF, %RF; %L, %R; %B; %LB; %RB 
rule : {10} 100 { remainder(time, 400)=0 and (0,0,0,0)=1 and (0,0,0,2)=3.1}  %upstair, intent to go down
rule : {uniform(0,1)} 100 { remainder(time, 400)=0 and (0,0,0,0)=1 and (0,0,0,1)>=5}   %inside the floor
rule : {11} 0 { (0,0,0,1)=5 and (0,0,0,0)>0.0 and (0,0,0,0)<=#Macro(Front) } %right move intent probability
rule : {12} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front) }
rule : {18} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {13} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {17} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {15} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {14} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {16} 0 { (0,0,0,1)=5 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0,0)<1 }
rule : {13} 0 { (0,0,0,1)=6 and (0,0,0,0)>0.0 and (0,0,0,0)<=#Macro(Front) } %up move intent probability
rule : {14} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front) }
rule : {12} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {15} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {11} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {17} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {16} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {18} 0 { (0,0,0,1)=6 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0,0)<1 }
rule : {15} 0 { (0,0,0,1)=7 and (0,0,0,0)>0.0 and (0,0,0,0)<=#Macro(Front) } %left move intent probability
rule : {14} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front) }
rule : {16} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {13} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {17} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {11} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {12} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {18} 0 { (0,0,0,1)=7 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0,0)<1 }
rule : {17} 0 { (0,0,0,1)=8 and (0,0,0,0)>0.0 and (0,0,0,0)<=#Macro(Front) } %down move intent probability
rule : {16} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front) }
rule : {18} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) }
rule : {15} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) }
rule : {11} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) }
rule : {13} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) }
rule : {12} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back) and (0,0,0,0)<=#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) }
rule : {14} 0 { (0,0,0,1)=8 and (0,0,0,0)>#Macro(Front)+#Macro(Left-Front)+#Macro(Right-Front)+#Macro(Left)+#Macro(Right)+#Macro(Back)+#Macro(Left-Back) and (0,0,0,0)<1 }

%phase 2: grant 
rule : {40} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (0,0,-1,0)=10 }   %downstair to choose
rule : {41} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (0,-1,0,0)=11 and (0,0,0,2)!=2}   %choose one neighbor to come in
rule : {42} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (1,-1,0,0)=12 and (0,0,0,2)!=2}
rule : {43} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (1,0,0,0)=13 and (0,0,0,2)!=2}
rule : {44} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (1,1,0,0)=14 and (0,0,0,2)!=2}
rule : {45} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (0,1,0,0)=15 and (0,0,0,2)!=2}
rule : {46} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (-1,1,0,0)=16 and (0,0,0,2)!=2}
rule : {47} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (-1,0,0,0)=17 and (0,0,0,2)!=2}
rule : {48} 100 { remainder(time, 400)=100 and (0,0,0,0)=0 and (-1,-1,0,0)=18 and (0,0,0,2)!=2}
rule : {(0,0,0,0)+10} 100 { remainder(time, 400)=100 and (0,0,0,0)>=10 and (0,0,0,0)<=18 }

%phase 3: ack, waiting // if intent doesn't grant, turn 39 and stay; random waiting (adding hotzone)
rule : {30} 100 { (0,0,0,0)=20 and (0,0,1,0)=40 }   %upstair ack
rule : {31} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=21 and (0,1,0,0)=41 }
rule : {32} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=22 and (-1,1,0,0)=42 }
rule : {33} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=23 and (-1,0,0,0)=43 }
rule : {34} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=24 and (-1,-1,0,0)=44 }
rule : {35} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=25 and (0,-1,0,0)=45 }
rule : {36} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=26 and (1,-1,0,0)=46 }
rule : {37} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=27 and (1,0,0,0)=47 }
rule : {38} { 100 + 400*randInt((0,0,0,3)) } { (0,0,0,0)=28 and (1,1,0,0)=48 }
rule : {39} 100 { remainder(time, 400)=200 and (0,0,0,0)>=20 and (0,0,0,0)<=28 }

%phase 4: move 
rule : {0} 100 { remainder(time, 400)=300 and (0,0,0,0)>=30 and (0,0,0,0)<=38 } %phase 4: move from
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=39 }                    %phase 4: cannot move from, remain 1
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=40 and (0,0,-1,0)=30}   %phase 4: move down //stair
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=41 and (0,-1,0,0)=31}   %phase 4: move to
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=42 and (1,-1,0,0)=32}
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=43 and (1,0,0,0)=33}
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=44 and (1,1,0,0)=34}
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=45 and (0,1,0,0)=35}
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=46 and (-1,1,0,0)=36}
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=47 and (-1,0,0,0)=37}
rule : {1} 100 { remainder(time, 400)=300 and (0,0,0,0)=48 and (-1,-1,0,0)=38}

rule : {(0,0,0,0)} 100 { t } 

[pathway]
%initial //near exit or downstair, find road back to the entrance
rule : {5} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 4 or (0,0,0,1) = 3.1) }
rule : {5} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3) and ((0,1,0,0)>4)}
rule : {7} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3 or (0,0,0,1) = 3.2) and ((0,-1,0,0)>4)}
rule : {6} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3 or (0,0,0,1) = 3.2) and ((-1,0,0,0)>4)}
rule : {8} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3 or (0,0,0,1) = 3.2) and ((1,0,0,0)>4)}
%rule : {5} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3) and ((0,1,0,1)=4 or (0,1,0,1)=3.1 or (0,1,0,0)>4)}
%rule : {7} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3 or (0,0,0,1) = 3.2) and ((0,-1,0,1)=4 or (0,-1,0,1)=3.1 or (0,-1,0,0)>4)}
%rule : {6} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3 or (0,0,0,1) = 3.2) and ((-1,0,0,1)=4 or (-1,0,0,1)=3.1 or (-1,0,0,0)>4)}
%rule : {8} 0 { (0,0,0,0) = 0 and ((0,0,0,1) = 0 or (0,0,0,1) = 3 or (0,0,0,1) = 3.2) and ((1,0,0,1)=4 or (1,0,0,1)=3.1 or (1,0,0,0)>4)}
rule : {(0,0,0,0)} 100 { t } 

[layout]
rule : {(0,0,0,0)} 100 { t } 

[hotzone]
rule : {(0,0,0,0)} 100 { t } 

